package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.ShareStaticDto;

import java.util.List;

/**
 * 分享时间统计
 * Created by xuefeng on 2018/7/31.
 */
@AdvancedFeignClient
public interface RemoteShareStaticService {

    /** 根据用户id查询
     *
     * @param userId
     * @return
     */
    List<ShareStaticDto> selectByUserId(Long userId);

    /** 根据用户id查询
     *
     * @param userId
     * @return
     */
    PageDto<ShareStaticDto> selectPageByUserId(PageDto<Long> pageDto);

    /**
     * 记录内容分享时间
     * @param userId
     * @param contentId
     * @param contentType
     * @return
     */
    Boolean record(Long userId, Long contentId, Integer contentType);
}
