package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.UserStaticDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiContentReq;

import java.util.List;

/**
 * 用户,内容维度 统计数据
 * Created by xuefeng on 2018/7/31.
 */
@AdvancedFeignClient
public interface RemoteUserStaticService {

    /** 根据用户id查询
     *
     * @param userId
     * @return
     */
    List<UserStaticDto> selectByUserId(Long userId);

    /** 根据用户id查询 上次查询数据
     *
     * @param userId
     * @return
     */
    List<UserStaticDto> selectLastByUserId(Long userId);

    /**
     * 插入用户此次查询数据
     * @param userId
     */
    void insertLast(Long userId);

    /**
     *
     * 根据用户和内容查询
     * @param userId
     * @param contentReqs
     * @return
     */
    List<UserStaticDto> selectByUserIdAndContents(Long userId, List<YoutuiContentReq> contentReqs);
}
