package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiSystemConfigDto;

import java.util.List;

/**
 * 友推的配置项
 * @author lichao 2018/6/26
 */
@AdvancedFeignClient
public interface RemoteYoutuiConfigService {

    /**
     * 通过key查value
     */
    String selectByKey(String key);

    /**
     * 配置key
     */
    Boolean configByKey(String key,String value,String desc);

    /**
     * 查询系统配置列表
     * @return
     */
    List<YoutuiSystemConfigDto> selectSystemConfigList();

    /**
     * 修改系统配置
     * @param youtuiSystemConfigDto
     */
    void updateSystemConfig(YoutuiSystemConfigDto youtuiSystemConfigDto);

    /**
     * 新增系统盘配置
     * @param dto
     * @return
     */
    Long insertSystemConfig(YoutuiSystemConfigDto dto);

}
