package cn.com.duiba.tuia.youtui.center.api.util;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

/**
 * author: 胡 朋
 * github: https://github.com/xiaomoinfo
 * email : xiaomo@xiaomo.info
 * QQ    : 83387856
 * Date  : 2018/7/10 11:21
 * desc  :
 */
public class DataTool {
    private DataTool(){}

    /**
     * 除法
     * @param num1
     * @param num2
     * @return
     */
    public static Long devide(Long num1, Long num2) {
        BigDecimal bigDivisor = new BigDecimal(num1);
        BigDecimal bigDividend = new BigDecimal(num2);
        return bigDivisor.divide(bigDividend, 0, BigDecimal.ROUND_HALF_UP).longValue();
    }


    /**
     * 向map里设置值

     */
    public static void mapPut(Map<String,String> map, String value, String name) {
        if(StringUtils.isNotBlank(value)&& !Objects.equals("null",value)){
            map.put(name,value);
        }
    }


    /** 类型转换 */
    public static <R> R convert(String value, Function<String, R> funtion) {
        if (StringUtils.isBlank(value)||Objects.equals("null",value)) {
            return null;
        }
        return funtion.apply(value);
    }

    /** 在extInfo中获取值 */
    public static String getValueFromExtInfo(String extInfo,String key,String defaultValue){

        if(StringUtils.isBlank(extInfo)){
            return defaultValue;
        }
        JSONObject jsonObject = JSONObject.parseObject(extInfo);
        return (String)jsonObject.getOrDefault(key,defaultValue);
    }

}
