package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

/**
 * author: 胡 朋
 * github: https://github.com/xiaomoinfo
 * email : xiaomo@xiaomo.info
 * QQ    : 83387856
 * Date  : 2018/7/10 11:20
 * desc  :
 */

import cn.com.duiba.tuia.youtui.center.api.util.DataTool;

import java.io.Serializable;

/**
 * 有推分享奖励系数
 */
public class RewardFactorDto implements Serializable {


    private static final long serialVersionUID = -2185714766701457361L;

    /**
     * 奖励系数
     */
    private Long rewardFactorNum;
    /**
     * 备注
     *
     */
    private String note;

    /**
     *  单个用户获得最高金额
     */
    private Long maxAmount;

    /**
     * 操作信息
     */
    private String operationInfo;

    /**
     * 当前日期
     */
    private String curDate;


    public Long getRewardFactorNum() {
        return rewardFactorNum;
    }

    public void setRewardFactorNum(Long rewardFactorNum) {
        this.rewardFactorNum = rewardFactorNum;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Long getMaxAmount() {
        return maxAmount;
    }

    public void setMaxAmount(Long maxAmount) {
        this.maxAmount = maxAmount;
    }

    public String getOperationInfo() {
        return operationInfo;
    }

    public void setOperationInfo(String operationInfo) {
        this.operationInfo = operationInfo;
    }

    public String getCurDate() {
        return curDate;
    }

    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    /**
     * 计算分成
     * @param amount
     * @return
     */
    public Long calculate(Long amount) {
        Long result = DataTool.devide(amount * getRewardFactorNum(), 10000L);
        return result;
    }

    /**
     * 计算分成（限制最大值）
     * @param amount
     * @return
     */
    public Long calculateLimitMax(Long amount) {
        Long result = DataTool.devide(amount * getRewardFactorNum(), 10000L);
        result = result > getMaxAmount() ? getMaxAmount() : result;
        return result;
    }
}

