package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.req.ReqHotAirticle;
import cn.com.duiba.tuia.youtui.center.api.dto.rsp.YoutuiArticlePulishRsp;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiHotAirticleDto;

import java.util.List;

/**
 * Create by yuanwei
 * at 2018/8/14 0014 下午 17:40
 */
@AdvancedFeignClient
public interface RemoteHotAirticleService {

    /**
     * 查询热文列表
     * @param req
     * @return
     */
    PageDto<YoutuiHotAirticleDto> selectHotAirticleList(ReqHotAirticle req);

    /**
     * 通过id查询热文详情
     * @param id
     * @return
     */
    YoutuiHotAirticleDto selectHotAirticById(Long id);

    /**
     * 通过id集合查询热文详情
     * @param ids
     * @return
     */
    List<YoutuiHotAirticleDto> listByIds(List<Long> ids);

    /**
     * 通过id删除热文
     * @param id
     * @return
     */
    int deleteHotAirticleById(Long id);

    /**
     * 新增热文
     * @param dto
     * @return
     */
    Long insertHotAirticle(YoutuiHotAirticleDto dto);

    /**
     * 修改热文
     * @param dto
     * @return
     */
    Long updateHotAirticle(YoutuiHotAirticleDto dto);

    /**
     * 上下线热文
     * @param id
     * @return
     */
    Long upDownLineHotAirticle(Long id,Integer isPublish);

    /**
     * 推荐或者取消推荐热文
     * @return
     */
    Long recommendHotAirticleOrNot(Long id,Integer isRecommend );

    /**
     * 批量插入热文
     * @param dtos
     * @return
     */
    int batchInsert(List<YoutuiHotAirticleDto> dtos);

    /**
     * 热文按标题去重
     * @param dtos
     * @return
     */
    List<YoutuiHotAirticleDto> removeDuplicateText(List<YoutuiHotAirticleDto> dtos);

    /**
     * 批量删除文章通过ids
     * @param ids
     * @return
     */
    Boolean batchDeleteArticles(List<Long> ids);

    /**
     * 获取全部的可发布的待发布文章
     * @return
     */
    YoutuiArticlePulishRsp getAllArticleData();

    /**
     * 批量上架文章
     * @param idList
     * @return
     */
    Boolean batchPublishArticles(List<Long> idList);

    /**
     * 获取定时发布的文章详情
     * @return
     */
    YoutuiArticlePulishRsp getTimingPublishData(Integer totalNum,Integer recommendNum,String runTime);

    /**
     * 保存定时发布的文章
     * @param rsp
     * @return
     */
    Boolean saveTimingPublishArticle(YoutuiArticlePulishRsp rsp);

    /**
     * 删除待选库文章到爬虫文章
     * @param id
     * @return
     */
    Boolean updateArticleState(Long id);

    /**
     * 通过发布时间发布待发布文章
     * @param publishTime
     * @return
     */
    Boolean publishTimingArticleByPtime(String publishTime);

    /**
     * 撤消定时发布
     * @return
     */
    Boolean revokeTimingArticle(Long id);

    /**
     * 批量下架文章
     * @param ids
     * @return
     */
    Boolean batchRevokePulish(List<Long> ids);

    /**
     * 批量删除待上架文章
     * @param ids
     * @return
     */
    Boolean batchUpdateArticleState(List<Long> ids);

    /**
     * 保存缩略图
     * @param id
     * @param url
     * @return
     */
    Boolean saveThumbnail(Long id,String url);

    /**
     * 查询上架热文ids
     * @param ids
     * @return
     */
    List<Long> selectPublishHotids(List<Long> ids);

    /**
     *  查询标题的文章存在数量，用户爬虫文章去重
     * @param title 文章标题
     * @return
     */
    Integer selectCountByTitle(String title);
}
