package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.rsp.ContentStaticRsp;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.*;

import java.util.List;

/**
 * Created by xuefeng on 2018/5/17.
 */
@AdvancedFeignClient
public interface RemoteYoutuiActivityService {

    /**
     * 获取内容分享列表
     * @return
     */
    List<ContentStaticRsp> getShareContents();

    /**
     * 获取内容分享列表
     * @return
     */
    List<ContentStaticRsp> getContents(List<YoutuiContentReq> list);

    /**
     * 根据id获取活动
     * @param id
     * @return
     */
    YoutuiActivityDto getById(Long id);

    /**
     * 根据ids获取活动
     * @return
     */
    List<YoutuiActivityDto> getByIds(List<Long> ids);

    /**
     * 查询活动皮肤的数据信息
     * @param activityId 活动id
     */
    YoutuiSkinDataDto selectActivitySkinByActivityId(Long activityId);


    /**
     * 查询活动的奖项
     * @param activityId 活动id
     * @param includeStock 是否包含库存
     * @return
     */
    List<YoutuiOptionDto> selectActivityOptionByActivityId(Long activityId, Boolean includeStock);

    /**
     * 通过skinType查询活动皮肤模板
     * @param skinType
     * @return
     */
    YoutuiSkinTemplateDto selectSkinTemplateBySkinType(String skinType);
}
