package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import cn.com.duiba.tuia.youtui.center.api.common.BaseDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Create by yuanwei
 * at 2018/6/29 0029 下午 16:18
 */
public class YoutuiPrizeManageDto extends BaseDto {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULPRIZERECOMMENDCONTENT = "正在火速处理中，查看进度请点击";
    private Long              id;

    /** title:奖品标题. */
    private String            title;

    /** prizeType:奖项类型. */
    private String            prizeType;

    /** listImage:列表图片. */
    private String            listImage;

    /** bannerImage:banner图. */
    private String            bannerImage;

    /** detailImage:详情图. */
    private String            detailImage;

    /** description:.说明 */
    private String            description;

    /** detailDesc:详细说明. */
    private String            detailDesc;

    /** stockId:库存id. */
    private Long              stockId;

    /** stock:库存值（管理端查询时用）. */
    private Integer           stock;

    /** totalStock:总库存(管理端查询时用) */
    private Integer           totalStock;

    /** stockChange:库存变化值（管理端保存时用）. */
    private Integer           stockChange;

    /** visionPlanner:视觉. */
    private String            visionPlanner;

    /** isOpen:是否开启. */
    private Boolean           isOpen;

    /** isDeleted:是否删除. */
    private Boolean           isDeleted;

    /**中奖弹层文案**/
    private String prizeRecommendContent;

    /** 以json string格式保存的扩展信息*/
    private String extInfo;

    /** 奖品价值，以json格式保存在extInfo中*/
    private Integer prizeValue;

    /** virtualType:虚拟商品类型. */
    private Integer          virtualType;

    /** virtualType:虚拟商品子类型. */
    private Integer          subType;

    /** 批次id*/
    private String           batchId;

    /** accountSwitch:账号开关(0:关 1：开). */
    private Integer accountSwitch;

    private List<String> stockIds;

    /** 是否是老数据 0老 1新*/
    private Integer isOld;


    public YoutuiPrizeManageDto() {
        super();
    }

    public YoutuiPrizeManageDto(Long id, Integer stockChange) {
        super();
        this.id = id;
        this.stockChange = stockChange;
    }


    public YoutuiPrizeManageDto(Long id, Boolean isOpen) {
        super();
        this.id = id;
        this.isOpen = isOpen;
    }

    public Integer getPrizeValue() {
        return prizeValue;
    }

    public void setPrizeValue(Integer prizeValue) {
        this.prizeValue = prizeValue;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    public String getListImage() {
        return listImage;
    }

    public void setListImage(String listImage) {
        this.listImage = listImage;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public String getDetailImage() {
        return detailImage;
    }

    public void setDetailImage(String detailImage) {
        this.detailImage = detailImage;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDetailDesc() {
        return detailDesc;
    }

    public void setDetailDesc(String detailDesc) {
        this.detailDesc = detailDesc;
    }

    public Long getStockId() {
        return stockId;
    }

    public void setStockId(Long stockId) {
        this.stockId = stockId;
    }

    public Integer getStock() {
        return stock;
    }

    public void setStock(Integer stock) {
        this.stock = stock;
    }

    public Integer getTotalStock() {
        return totalStock;
    }

    public void setTotalStock(Integer totalStock) {
        this.totalStock = totalStock;
    }

    public Integer getStockChange() {
        return stockChange;
    }

    public void setStockChange(Integer stockChange) {
        this.stockChange = stockChange;
    }

    public String getVisionPlanner() {
        return visionPlanner;
    }

    public void setVisionPlanner(String visionPlanner) {
        this.visionPlanner = visionPlanner;
    }

    public Boolean getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public Boolean getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }


    public String getBatchId() {
        return batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }


    public void setValueByExtInfo() {
        if(StringUtils.isNotBlank(this.getExtInfo())) {
            JSONObject jsonObject = JSONObject.parseObject(this.getExtInfo());
            this.setPrizeValue(jsonObject.getIntValue("prizeValue"));
            JSONArray jsonArray = jsonObject.getJSONArray("stockIds");
            if(jsonArray!=null) {
                this.setStockIds(jsonArray.toJavaList(String.class));
            }
        }
    }

    public void setExtInfoByValue(){
        Map<String,Object> map = new HashMap<>(1);
        map.put("prizeValue",this.getPrizeValue());
        map.put("stockIds",this.getStockIds());
        this.setExtInfo(JSON.toJSONString(map));
    }


    public Integer getAccountSwitch() {
        return accountSwitch;
    }

    public void setAccountSwitch(Integer accountSwitch) {
        this.accountSwitch = accountSwitch;
    }


    public Integer getVirtualType() {
        return virtualType;
    }


    public void setVirtualType(Integer virtualType) {
        this.virtualType = virtualType;
    }


    public Integer getSubType() {
        return subType;
    }


    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getPrizeRecommendContent() {
        return prizeRecommendContent;
    }

    public void setPrizeRecommendContent(String prizeRecommendContent) {
        this.prizeRecommendContent = prizeRecommendContent;
    }

    public Integer getIsOld() {
        return isOld;
    }

    public void setIsOld(Integer isOld) {
        this.isOld = isOld;
    }

    public List<String> getStockIds() {
        return stockIds;
    }

    public void setStockIds(List<String> stockIds) {
        this.stockIds = stockIds;
    }

}
