/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.youtui.center.api.util;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class SignTool {
    public static boolean signVerify(String appSecret, Map<String, String> params) {
        String sign = SignTool.sign(appSecret, params);
        return sign.equals(params.get("sign"));
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static String sign(String appSecret, Map<String, String> params) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("appSecret", appSecret);
        for (String key : params.keySet()) {
            if (key.equals("sign")) continue;
            map.put(key, params.get(key));
        }
        String sign = SignTool.sign(map);
        return sign;
    }

    public static String sign(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String string = "";
        for (String s : keys) {
            string = string + params.get(s);
        }
        String sign = "";
        try {
            sign = SignTool.toHexValue(SignTool.encryptMD5(string.getBytes(Charset.forName("utf-8"))));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("sign md5 error");
        }
        return sign;
    }

    public static String sign4pdd(Map<String, String> params, String clientSecret) {
        params.remove("clientSecret");
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String string = clientSecret;
        for (String s : keys) {
            string = string + s + params.get(s);
        }
        string = string + clientSecret;
        String sign = "";
        try {
            byte[] bytes = DigestUtils.md5((String)string);
            sign = new String(Hex.encodeHex((byte[])bytes, (boolean)false));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("sign4pdd md5 error");
        }
        return sign;
    }

    private static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    public static void main(String[] args) {
        String appKey = "key";
        String appSecret = "secret";
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("appKey", appKey);
        params.put("appSecret", appSecret);
        params.put("date", new Date().getTime() + "");
        String sign = SignTool.sign(params);
        params.put("sign", sign);
        System.out.println(SignTool.signVerify(appSecret, params));
        TreeMap<String, String> params4pdd = new TreeMap<String, String>();
        params4pdd.put("access_token", "asd78172s8ds9a921j9qqwda12312w1w21211");
        params4pdd.put("client_id", "1");
        params4pdd.put("data_type", "XML");
        params4pdd.put("order_status", "1");
        params4pdd.put("page", "1");
        params4pdd.put("page_size", "10");
        params4pdd.put("timestamp", "1480411125");
        params4pdd.put("type", "pdd.order.number.list.get");
        System.err.println(SignTool.sign4pdd(params4pdd, "testSecret"));
    }
}

