package cn.com.duiba.tuia.youtui.center.api.constant.youtui;


/**
 * 消息中心-关联内容的枚举
 * Created by liyuanzeng on 2018/8/30.
 */
public enum MessageRelationType {

    Context(0, "内容"),
    Url(1,"链接"),
    Other(2,"不关联"),
    ;

    private Integer code;
    private String desc;

    MessageRelationType(Integer type, String desc) {
        this.code = type;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static MessageRelationType getMessageRelationType(Integer code) {
        for (MessageRelationType messageRelationType : MessageRelationType.values()) {
            if (code.equals(messageRelationType.getCode())) {
                return messageRelationType;
            }
        }
        return null;
    }

}
