package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.ShareStaticDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.ShareStaticNumDto;

import java.util.List;

/**
 * 分享时间统计
 * Created by xuefeng on 2018/7/31.
 */
@AdvancedFeignClient
public interface RemoteShareStaticService {

    /** 根据用户id查询
     *
     * @param userId
     * @return
     */
    List<ShareStaticDto> selectByUserId(Long userId);

    /**
     * 根据用户id,内容查询
     *
     * @param userId
     * @return
     */
    ShareStaticDto selectByUserIdAndContent(Long userId, Integer contentType, Long contentId);

    /** 根据用户id查询
     *
     * @param pageDto
     * @return
     */
    PageDto<ShareStaticDto> selectPageByUserId(PageDto<Long> pageDto);

    /**
     * 记录内容分享时间
     * @param userId
     * @param contentId
     * @param contentType
     * @return
     */
    Boolean record(Long userId, Long contentId, Integer contentType);

    /**
     * 我的分享-文章、活动数
     * @param userId
     * @return
     */
    ShareStaticNumDto selectSharedNum(Long userId);

    /**
     * 查询一组用户分享热文
     * @param userId
     * @param page 当前页码
     * @return
     */
    List<Long> selectSharedHottext(Long userId, int page);
}
