package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;


import cn.com.duiba.tuia.youtui.center.api.dto.youtui.BaseDto;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 推广频道
 */
public class PDDChannelDto extends BaseDto {
    /**
     * 商城推广链接
     */
    private String url;
    /**
     * 商城推广短链接
     */
    private String shortUrl;
    /**
     * 商城推广移动链接
     */
    private String mobileUrl;
    /**
     * 商城推广移动短链接
     */
    private String mobileShortUrl;
    /**
     * 商城推广多人团链接
     */
    private String multiGroupUrl;
    /**
     * 商城推广多人团短链接
     */
    private String multiGroupShortUrl;
    /**
     * 商城推广多人团移动链接
     */
    private String multiGroupMobileUrl;
    /**
     * 商城推广多人团移动短链接
     */
    private String multiGroupMobileShortUrl;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getShortUrl() {
        return shortUrl;
    }

    public void setShortUrl(String shortUrl) {
        this.shortUrl = shortUrl;
    }

    public String getMobileUrl() {
        return mobileUrl;
    }

    public void setMobileUrl(String mobileUrl) {
        this.mobileUrl = mobileUrl;
    }

    public String getMobileShortUrl() {
        return mobileShortUrl;
    }

    public void setMobileShortUrl(String mobileShortUrl) {
        this.mobileShortUrl = mobileShortUrl;
    }

    public String getMultiGroupUrl() {
        return multiGroupUrl;
    }

    public void setMultiGroupUrl(String multiGroupUrl) {
        this.multiGroupUrl = multiGroupUrl;
    }

    public String getMultiGroupShortUrl() {
        return multiGroupShortUrl;
    }

    public void setMultiGroupShortUrl(String multiGroupShortUrl) {
        this.multiGroupShortUrl = multiGroupShortUrl;
    }

    public String getMultiGroupMobileUrl() {
        return multiGroupMobileUrl;
    }

    public void setMultiGroupMobileUrl(String multiGroupMobileUrl) {
        this.multiGroupMobileUrl = multiGroupMobileUrl;
    }

    public String getMultiGroupMobileShortUrl() {
        return multiGroupMobileShortUrl;
    }

    public void setMultiGroupMobileShortUrl(String multiGroupMobileShortUrl) {
        this.multiGroupMobileShortUrl = multiGroupMobileShortUrl;
    }

    public static class Req extends PDDBaseReq{
        /**
         * 推广位列表，例如：["60005_612"]
         */
        private List<String> pIdList = Collections.singletonList(PDDConstant.PID);
        /**
         * 唤起微信app推广短链接
         */
        private Boolean weAppWebViewShortUrl = false;
        /**
         * 唤起微信app推广链接
         */
        private Boolean weAppWebWiewUrl = false;
        /**
         * 自定义参数
         */
        private String customParameters ;

        /**
         * 0, "1.9包邮"；1, "今日爆款"； 2, "品牌清仓"； 3, "默认商城"；4,"PC端专属商城"；非必填 ,默认是3,
         */
        private Integer channelType;

        public String getCustomParameters() {
            return customParameters;
        }

        public void setCustomParameters(String customParameters) {
            this.customParameters = customParameters;
        }

        public Integer getChannelType() {
            return channelType;
        }

        public void setChannelType(Integer channelType) {
            this.channelType = channelType;
        }

        public List<String> getpIdList() {
            return pIdList;
        }

        public void setpIdList(List<String> pIdList) {
            this.pIdList = pIdList;
        }

        public Boolean getWeAppWebViewShortUrl() {
            return weAppWebViewShortUrl;
        }

        public void setWeAppWebViewShortUrl(Boolean weAppWebViewShortUrl) {
            this.weAppWebViewShortUrl = weAppWebViewShortUrl;
        }

        public Boolean getWeAppWebWiewUrl() {
            return weAppWebWiewUrl;
        }

        public void setWeAppWebWiewUrl(Boolean weAppWebWiewUrl) {
            this.weAppWebWiewUrl = weAppWebWiewUrl;
        }

        @Override
        public String getType() {
            return "pdd.ddk.cms.prom.url.generate";
        }

        /**
         * 生成加密参数MAP
         *
         * @return
         */
        @Override
        public Map<String, String> toMap() {
            Map<String, String> paramsMap = super.toMap();
            paramsMap.put("p_id_list", "[" + this.getpIdList().stream().map(o -> "\"" + o + "\"").collect(Collectors.joining(",")) + "]");
            paramsMap.put("we_app_web_view_short_url", this.getWeAppWebViewShortUrl().toString());
            paramsMap.put("we_app_web_wiew_url", this.getWeAppWebWiewUrl().toString());
            paramsMap.put("channel_type", this.getChannelType().toString());
            paramsMap.put("custom_parameters", this.getCustomParameters());
            return paramsMap;
        }
    }

    public static void main(String[] args) throws Exception {
        Req req = new Req();
        req.setChannelType(2);
        System.out.println(req.request());
    }
}
