package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Create by yuanwei
 * at 2018/10/22 0022 下午 15:08
 */
@ApiModel("趣晒天天乐用户号码记录DTO")
public class YoutuiTtlUserRecordDto implements Serializable{

    @ApiModelProperty("唯一键id")
    private Long id;
    @ApiModelProperty("用户id")
    private Long userId;
    @ApiModelProperty("中奖号码id")
    private Long prizeId;
    @ApiModelProperty("奖票号码")
    private List<TicketNumber> ticketNumber;
    @ApiModelProperty("奖项中奖个数，0-未中奖，1-未中奖，2-未中奖，3-未中奖，4-幸运奖，5-三等奖，6-二等奖，7-一等奖")
    private Integer ticketLevel;
    @ApiModelProperty("中奖金额")
    private Long prizeAmout;
    @ApiModelProperty("是否兑奖过，0-未兑奖，1-已兑奖")
    private Integer ticketState;
    @ApiModelProperty("奖票期数")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date endTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(Long prizeId) {
        this.prizeId = prizeId;
    }

    public List<TicketNumber> getTicketNumber() {
        return ticketNumber;
    }

    public void setTicketNumber(List<TicketNumber> ticketNumber) {
        this.ticketNumber = ticketNumber;
    }

    public Integer getTicketLevel() {
        return ticketLevel;
    }

    public void setTicketLevel(Integer ticketLevel) {
        this.ticketLevel = ticketLevel;
    }

    public Long getPrizeAmout() {
        return prizeAmout;
    }

    public void setPrizeAmout(Long prizeAmout) {
        this.prizeAmout = prizeAmout;
    }

    public Integer getTicketState() {
        return ticketState;
    }

    public void setTicketState(Integer ticketState) {
        this.ticketState = ticketState;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @ApiModel("奖票号码类")
    private static class TicketNumber implements Serializable{

        @ApiModelProperty("号码")
        private String number;
        @ApiModelProperty("是否匹配到中奖")
        private Integer isHit;

        public String getNumber() {
            return number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public Integer getIsHit() {
            return isHit;
        }

        public void setIsHit(Integer isHit) {
            this.isHit = isHit;
        }
    }
}
