package cn.com.duiba.tuia.union.star.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.domain.rsp.DeviceUaInfoDto;

import java.util.List;

/**
 * 设备ua解析Service
 * @Author: xingbo
 * @Date: 2021/6/1 2:43
 */
@AdvancedFeignClient
public interface RemoteDeviceUaParseService {
    /**
     * 查询品牌列表
     */
    List<DeviceUaInfoDto> deviceUaList(DeviceUaInfoDto deviceUaInfoDto);

    /**
     * 保存ua解析得到的设备信息
     * @param deviceUaInfoDto
     * @return
     */
    int saveDeviceUaInfo(DeviceUaInfoDto deviceUaInfoDto);

    /**
     * 手动更新设备信息
     */
    int updateDeviceInfo(DeviceUaInfoDto deviceUaInfoDto);

    /**
     * 删除设备信息（物理删除）
     */
    int deleteDeviceInfo(Long id);

    /**
     * 批量删除设备信息（物理删除）
     */
    int deleteDeviceInfos(Long[] ids);

    /**
     * 根据id查找设备
     */
    DeviceUaInfoDto selectMobileUaInfoById(Long id);

    /**
     * 根据设备型号查找设备
     */
    DeviceUaInfoDto selectMobileUaInfoByPhoneModel(String phoneModel);
}
