package cn.com.duiba.tuia.union.star.center.api.remoteservice.domain.config;

import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Map;

/**
 * @author jackxueman
 */
@Getter
@Setter
@ToString
@Builder
public class QrCodeConfig implements Serializable {
    private static final MatrixToImageConfig DEFAULT_CONFIG = new MatrixToImageConfig();

    /**
     * The message to put into QrCode
     */
    private String msg;


    /**
     * qrcode center logo
     */
    private String logo;


    /**
     * qrcode image width
     */
    private Integer w;


    /**
     * qrcode image height
     */
    private Integer h;


    /**
     * qrcode bgcolor, default white
     */
    private Integer offColor;


    /**
     * qrcode msg color, default black
     */
    private Integer onColor;


    /**
     * qrcode message's code, default UTF-8
     */
    private String code;


    /**
     * 0 - 4
     */
    private Integer padding;


    /**
     * error level, default H
     */
    private ErrorCorrectionLevel errorCorrection;

    /**
     * 生成二维码的颜色
     */
    private MatrixToImageConfig matrixToImageConfig;


    private Map<EncodeHintType, Object> hints;

    /**
     * output qrcode image type, default png
     */
    private String picType;

    private String text;

    //private

   /* public QrCodeConfig() {
        super();
    }

    public QrCodeConfig(String msg) {
        this.msg = msg;
    }*/

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public Integer getW() {
        return w == null ? (h == null ? 200 : h) : w;
    }

    public void setW(Integer w) {
        if (w != null && w < 0) {
            throw new IllegalArgumentException("???????????0");
        }
        this.w = w;
    }

    public Integer getH() {
        if (w != null && w < 0) {
            throw new IllegalArgumentException("???????????0");
        }
        return h == null ? (w == null ? 200 : w) : h;
    }

    public void setH(Integer h) {
        this.h = h;
    }

    public Integer getOffColor() {
        return offColor == null ? MatrixToImageConfig.WHITE : offColor;
    }

    public void setOffColor(Integer offColor) {
        this.offColor = offColor;
    }

    public Integer getOnColor() {
        return onColor == null ? MatrixToImageConfig.BLACK : onColor;
    }

    public void setOnColor(Integer onColor) {
        this.onColor = onColor;
    }

    public String getCode() {
        return code == null ? "UTF-8" : code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getPadding() {
        if (padding == null) {
            return 1;
        }

        if (padding < 0) {
            return 0;
        }

        if (padding > 4) {
            return 4;
        }

        return padding;
    }

    public void setPadding(Integer padding) {
        this.padding = padding;
    }


    public String getPicType() {
        return picType == null ? "png" : picType;
    }

    public void setPicType(String picType) {
        this.picType = picType;
    }



    public ErrorCorrectionLevel getErrorCorrection() {
        return errorCorrection == null ? ErrorCorrectionLevel.H : errorCorrection;
    }

    public void setErrorCorrection(ErrorCorrectionLevel errorCorrection) {
        this.errorCorrection = errorCorrection;
    }

    private void validate() {
        if (msg == null || msg.length() == 0) {
            throw new IllegalArgumentException("二维码内容不能为空");
        }
    }

}
