package cn.com.duiba.tuia.union.star.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.domain.rsp.UrlShortLongDTO;

import java.util.List;

/**
 * 域名长链转短链Service接口
 *
 * @author YanfeiAndAHai
 * @date 2021-02-05
 */
@AdvancedFeignClient
public interface RemoteUrlShortLongService {
    /**
     * 查询域名长链转短链
     *
     * @param id 域名长链转短链ID
     * @return 域名长链转短链
     */
    UrlShortLongDTO selectUrlShortLongById(Long id);

    /**
     * 根据短链字符查询长链关系
     *
     * @param shortUk 短链唯一字符
     * @return 域名长链转短链
     */
    UrlShortLongDTO selectUrlShortLongByShortUk(String shortUk);

    /**
     * 查询域名长链转短链列表
     *
     * @param urlShortLongDTO 域名长链转短链
     * @return 域名长链转短链集合
     */
    List<UrlShortLongDTO> selectUrlShortLongList(UrlShortLongDTO urlShortLongDTO);

}
