package cn.com.duiba.user.service.api.dto.user;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by zhangshun on 2019/2/13.
 */
@Data
@ToString
public class UserDto implements Serializable {

    private static final long serialVersionUID = 7507965674033770342L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 唯一ID，同一主体下唯一
     */
    private String unionId;

    /**
     * 用户的昵称
     */
    private String nickname;

    /**
     * 昵称拼音
     */
    private String nicknamePy;

    /**
     * 昵称拼音首字母
     */
    private String nicknamePyFast;

    /**
     * 用户性别，1=男性，2=女性，0=未知
     */
    private Integer gender;

    /**
     * 用户的头像
     */
    private String avatar;

    /**
     * 用户手机号
     */
    private String phone;

    /**
     * 手机国家code
     */
    private String phoneCountryCode;

    /**
     * 用户所在国家
     */
    private String country;

    /**
     * 用户所在省
     */
    private String province;

    /**
     * 用户所在市
     */
    private String city;

    /**
     * 备注
     */
    private String remark;

    /**
     * 微信用户的语言
     */
    private String lang;

    /**
     * 平台类型
     * @see cn.com.duiba.user.service.api.enums.user.PlatformTypeEnum
     */
    private Integer platformType;
}
