package cn.com.duiba.user.service.api.enums.user;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 用户平台类型枚举
 *
 * @author xuzhigang
 * @date 2021/1/27 6:02 下午
 **/
@Getter
@AllArgsConstructor
public enum PlatformTypeEnum {
    KJJ_PLATFORM(1, "客集集"),

    THIRD_PART_PLATFORM(2, "第三方平台"),

    CORP_WECHAT(3, "企微用户"),
    ;

    /**
     * 平台类型
     */
    private Integer platformType;

    /**
     * 描述
     */
    private String desc;

    public static PlatformTypeEnum getByCode(Integer code) {
        for (PlatformTypeEnum value : PlatformTypeEnum.values()) {
            if (value.getPlatformType().equals(code)) {
                return value;
            }
        }
        return null;
    }
}
