package cn.com.duiba.user.service.api.remoteservice.wxwork;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.service.api.dto.wxwork.WxWorkCorpDto;
import cn.com.duiba.user.service.api.param.wxwork.WxWorkCorpInitParam;
import cn.com.duiba.user.service.api.param.wxwork.ProviderCorpInitParam;

/**
 * 企微账号相关操作。
 * 包含第三方服务商，授权的第三方企微账号，未来也可能支持我们自己的企微账号，代理企微账号等
 * @author dugq
 * @date 2021/11/23 10:53 上午
 */
@AdvancedFeignClient
public interface RemoteWxWorkCorpService {

    /**
     * 初始化一个第三方服务商
     */
    long initProviderCorp(ProviderCorpInitParam initParam);

    /**
     * 初始化一个企微账号
     */
    long initCorp(WxWorkCorpInitParam initParam);

    /**
     * 根据ID查询
     */
    WxWorkCorpDto selectById(Long id);

    /**
     * 根据corpKey(企微的corpid)查询
     */
    WxWorkCorpDto selectByKey(String corpKey);
}
