package cn.com.duiba.wolf.utils;

import net.sf.cglib.beans.BeanCopier;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * bean 工具类
 * Created by wenqi.huang on 16/6/13.
 */
public class BeanUtils {
    private static ConcurrentMap<Class, ConcurrentMap<Class, BeanCopier>> beanCopierMap = new ConcurrentHashMap<>();

    /**
     * 复制属性, 会自动缓存以加快速度
     * @param src
     * @param dest
     */
    public static void copy(Object src, Object dest){
        if(src == null){
            throw new NullPointerException("src is null");
        }
        if(dest == null){
            throw new NullPointerException("dest is null");
        }
        ConcurrentMap<Class, BeanCopier> innerMap = beanCopierMap.get(src.getClass());
        if(innerMap == null){
            innerMap = new ConcurrentHashMap();
            ConcurrentMap<Class, BeanCopier> temp = beanCopierMap.putIfAbsent(src.getClass(), innerMap);
            if(temp != null){
                innerMap = temp;
            }
        }
        BeanCopier beanCopier = innerMap.get(dest.getClass());
        if(beanCopier == null) {
            beanCopier = BeanCopier.create(src.getClass(),
                    dest.getClass(), false);
            BeanCopier temp = innerMap.putIfAbsent(dest.getClass(), beanCopier);
            if(temp != null) {
                beanCopier = temp;
            }
        }
        beanCopier.copy(src, dest, null);
    }

    /**
     * 复制属性, 会自动缓存以加快速度
     * @param src
     * @param destClass
     * @param <T>
     * @return
     */
    public static <T> T copy(Object src, Class<T> destClass){
        try {
            T dest = destClass.newInstance();
            copy(src, dest);
            return dest;
        } catch (InstantiationException e) {
            throw new RuntimeException(e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}
