/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.cglib.beans.BeanCopier;

public class BeanUtils {
    private static ConcurrentMap<Class, ConcurrentMap<Class, BeanCopier>> beanCopierMap = new ConcurrentHashMap<Class, ConcurrentMap<Class, BeanCopier>>();

    public static void copy(Object src, Object dest) {
        BeanCopier beanCopier;
        if (src == null) {
            throw new NullPointerException("src is null");
        }
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        ConcurrentMap<Class<?>, BeanCopier> innerMap = (ConcurrentHashMap)beanCopierMap.get(src.getClass());
        if (innerMap == null) {
            innerMap = new ConcurrentHashMap();
            ConcurrentMap temp = beanCopierMap.putIfAbsent(src.getClass(), innerMap);
            if (temp != null) {
                innerMap = temp;
            }
        }
        if ((beanCopier = (BeanCopier)innerMap.get(dest.getClass())) == null) {
            beanCopier = BeanCopier.create(src.getClass(), dest.getClass(), (boolean)false);
            BeanCopier temp = innerMap.putIfAbsent(dest.getClass(), beanCopier);
            if (temp != null) {
                beanCopier = temp;
            }
        }
        beanCopier.copy(src, dest, null);
    }

    public static <T> T copy(Object src, Class<T> destClass) {
        try {
            T dest = destClass.newInstance();
            BeanUtils.copy(src, dest);
            return dest;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

