package cn.com.duiba.wolf.dubbo;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;

/**
 * Created by wenqi.huang on 16/6/1.<br/>
 * dubbo拦截器
 */
@Activate(group = { Constants.PROVIDER })
public class RuntimeExceptionFilter implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RuntimeExceptionFilter.class);

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
//        RpcContext context = RpcContext.getContext();
//        boolean providerSide = context.isProviderSide();

        try {
            return invoker.invoke(invocation);
        }catch(RuntimeException e){
            log.error(e.getMessage(), e);
            try {
                Method m = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                Class<?> clazz = m.getReturnType();
                if(!clazz.equals(Void.TYPE)){
                    return new RpcResult(DubboResult.failResult(e.getMessage()));
                }else{
                    return new RpcResult();
                }
            } catch (NoSuchMethodException e1) {
                throw e;//抛出原来的异常
            }
        }

    }
}
