/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.dubbo;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcResult;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider"})
public class RuntimeExceptionFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RuntimeExceptionFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        try {
            return invoker.invoke(invocation);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            try {
                Method m = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                Class<?> clazz = m.getReturnType();
                if (!clazz.equals(Void.TYPE)) {
                    return new RpcResult((Object)DubboResult.failResult((String)e.getMessage()));
                }
                return new RpcResult();
            }
            catch (NoSuchMethodException e1) {
                throw e;
            }
        }
    }
}

