package cn.com.duiba.wolf.dubbo;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.*;
import com.alibaba.dubbo.rpc.service.GenericService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;

/**
 * Created by wenqi.huang on 16/6/1.<br/>
 * dubbo拦截器,写法参考dubbo自带的ExceptionFilter
 */
@Activate(group = { Constants.PROVIDER })
public class RuntimeExceptionFilter implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RuntimeExceptionFilter.class);

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        try {
            Result result = invoker.invoke(invocation);
            if (result.hasException() && GenericService.class != invoker.getInterface()) {
                try {
                    Throwable exception = result.getException();

                    // 如果是checked异常，直接抛出
                    if (! (exception instanceof RuntimeException) && (exception instanceof Exception)) {
                        return result;
                    }

                    // 是Dubbo本身的异常，直接抛出
                    if (exception instanceof RpcException) {
                        return result;
                    }

                    try {
                        // 在方法签名上有声明，直接抛出
                        Method method = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                        Class<?>[] exceptionClassses = method.getExceptionTypes();
                        for (Class<?> exceptionClass : exceptionClassses) {
                            if (exception.getClass().equals(exceptionClass)) {
                                return result;
                            }
                        }

                        Class<?> clazz = method.getReturnType();
                        if(clazz.equals(Void.TYPE)){
                            return result;//返回类型为void则强制抛出异常给客户端
                        }else if(clazz.equals(DubboResult.class)){//只有当返回类型为DubboResult时才应该捕获RuntimeException并封装错误信息
                            log.error(exception.getMessage(), exception);
                            return new RpcResult(DubboResult.failResult(exception.getMessage()));
                        }else{
                            return result;//强制抛出异常给客户端
                        }
                    } catch (NoSuchMethodException e) {
                        return result;
                    }

                    // 包装成RuntimeException抛给客户端
                    //return new RpcResult(new RuntimeException(StringUtils.toString(exception)));
                } catch (Throwable e) {
                    return result;
                }
            }
            return result;
        } catch (RuntimeException e) {
            throw e;
        }
    }
}
