/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentUtils.class);

    private ConcurrentUtils() {
    }

    public static void executeTasksBlocking(Executor executor, List<Runnable> runnables) {
        final CountDownLatch latch = new CountDownLatch(runnables.size());
        for (final Runnable r : runnables) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        r.run();
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public static <V> List<V> submitTasksBlocking(Executor executor, List<Callable<V>> callables) {
        final CountDownLatch latch = new CountDownLatch(callables.size());
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        for (final Callable<V> r : callables) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            Object v = r.call();
                            queue.add(v);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                            latch.countDown();
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            return new ArrayList(queue);
        }
        return new ArrayList(queue);
    }
}

