/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.math.RandomUtils;

public class TestUtils {
    private TestUtils() {
    }

    public static <T> T createRandomBean(Class<T> clazz) {
        return TestUtils.createRandomBean(clazz, false);
    }

    public static <T> T createRandomBean(Class<T> clazz, boolean includeParents) {
        T t = null;
        try {
            t = clazz.newInstance();
            TestUtils.setRandomAttributesForBean(t, includeParents);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return t;
    }

    public static void setRandomAttributesForBean(Object t, boolean includeParents) {
        TestUtils.setRandomAttributesForBean(t, t.getClass(), includeParents, false);
    }

    private static void setRandomAttributesForBean(Object t, Class<?> clazz, boolean includeParents, boolean overwriteValuesNotNull) {
        try {
            Class<?> parentClass;
            Field[] fields;
            Field[] fieldArray = fields = clazz.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (!f.getName().equals("id") && (f.getModifiers() & 8) != 8 && (f.getModifiers() & 0x10) != 16) {
                    f.setAccessible(true);
                    Object currentValue = f.get(t);
                    if (overwriteValuesNotNull || currentValue == null) {
                        Class<?> type = f.getType();
                        if (type.equals(String.class)) {
                            f.set(t, RandomStringUtils.random((int)3, (boolean)true, (boolean)true));
                        } else if (type.equals(Integer.class)) {
                            f.set(t, RandomUtils.nextInt((int)100000));
                        } else if (type.equals(Long.class)) {
                            f.set(t, RandomUtils.nextInt((int)100000));
                        } else if (type.equals(Date.class)) {
                            f.set(t, new Date());
                        } else if (type.equals(Boolean.class)) {
                            f.set(t, RandomUtils.nextBoolean());
                        }
                    }
                }
                ++n2;
            }
            if (includeParents && (parentClass = clazz.getSuperclass()) != null) {
                TestUtils.setRandomAttributesForBean(t, parentClass, includeParents, overwriteValuesNotNull);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void assertEqualsReflect(T t1, T t2, boolean includeParents, String[] exceptFields) {
        Class<?> c2;
        if (t1 == null && t2 == null) {
            return;
        }
        if (t1 == null) {
            throw new Error("left parameter is null");
        }
        if (t2 == null) {
            throw new Error("right parameter is null");
        }
        Class<?> c1 = t1.getClass();
        if (!c1.equals(c2 = t2.getClass())) {
            throw new Error("class not equal:[" + c1.getName() + "],  [" + c2.getName() + "]");
        }
        HashSet<String> exceptFieldSet = new HashSet<String>();
        if (exceptFields != null) {
            exceptFieldSet.addAll(Arrays.asList(exceptFields));
        }
        TestUtils.assertEqualsReflect(t1, t2, t1.getClass(), includeParents, exceptFieldSet);
    }

    private static <T> void assertEqualsReflect(T t1, T t2, Class<?> clazz, boolean includeParents, Set<String> exceptFieldSet) {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (!exceptFieldSet.contains(f.getName())) {
                try {
                    f.setAccessible(true);
                    Object fv1 = f.get(t1);
                    Object fv2 = f.get(t2);
                    if (!ObjectUtils.equals((Object)fv1, (Object)fv2)) {
                        throw new Error("field:[" + f.getName() + "] not equals,left is:" + fv1 + ", right is:" + fv2);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new Error(e);
                }
            }
            ++n2;
        }
        if (includeParents && (clazz = clazz.getSuperclass()) != null) {
            TestUtils.assertEqualsReflect(t1, t2, clazz, includeParents, exceptFieldSet);
        }
    }
}

