/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import cn.com.duiba.wolf.utils.NumberUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtils {
    public static List<Class<?>> getClassList(String pkgName, boolean isRecursive, Class<? extends Annotation> annotation) {
        ArrayList classList = new ArrayList();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            String strFile = pkgName.replaceAll("\\.", File.separator);
            Enumeration<URL> urls = loader.getResources(strFile);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                String pkgPath = url.getPath();
                if ("file".equals(protocol)) {
                    ClassUtils.findClassName(classList, pkgName, pkgPath, isRecursive, annotation);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                ClassUtils.findClassName(classList, pkgName, url, isRecursive, annotation);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return classList;
    }

    private static void findClassName(List<Class<?>> clazzList, String pkgName, String pkgPath, boolean isRecursive, Class<? extends Annotation> annotation) {
        if (clazzList == null) {
            return;
        }
        File[] files = ClassUtils.filterClassFiles(pkgPath);
        if (files != null) {
            for (File f : files) {
                String fileName = f.getName();
                if (f.isFile()) {
                    String clazzName = ClassUtils.getClassName(pkgName, fileName);
                    ClassUtils.addClassName(clazzList, clazzName, annotation);
                    continue;
                }
                if (!isRecursive) continue;
                String subPkgName = pkgName + "." + fileName;
                String subPkgPath = pkgPath + "/" + fileName;
                ClassUtils.findClassName(clazzList, subPkgName, subPkgPath, true, annotation);
            }
        }
    }

    private static void findClassName(List<Class<?>> clazzList, String pkgName, URL url, boolean isRecursive, Class<? extends Annotation> annotation) throws IOException {
        JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
        JarFile jarFile = jarURLConnection.getJarFile();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String jarEntryName = jarEntry.getName();
            String clazzName = jarEntryName.replace("/", ".");
            int endIndex = clazzName.lastIndexOf(".");
            String prefix = null;
            if (endIndex > 0) {
                String prefix_name = clazzName.substring(0, endIndex);
                if (clazzName.endsWith(".class")) {
                    clazzName = prefix_name;
                }
                if ((endIndex = prefix_name.lastIndexOf(".")) > 0) {
                    prefix = prefix_name.substring(0, endIndex);
                }
            }
            if (prefix == null || !jarEntryName.endsWith(".class")) continue;
            if (prefix.equals(pkgName)) {
                ClassUtils.addClassName(clazzList, clazzName, annotation);
                continue;
            }
            if (!isRecursive || !prefix.startsWith(pkgName)) continue;
            ClassUtils.addClassName(clazzList, clazzName, annotation);
        }
    }

    private static File[] filterClassFiles(String pkgPath) {
        if (pkgPath == null) {
            return null;
        }
        return new File(pkgPath).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".class") || file.isDirectory();
            }
        });
    }

    private static String getClassName(String pkgName, String fileName) {
        int endIndex = fileName.lastIndexOf(".");
        String clazz = null;
        if (endIndex >= 0) {
            clazz = fileName.substring(0, endIndex);
        }
        String clazzName = null;
        if (clazz != null) {
            clazzName = pkgName + "." + clazz;
        }
        return clazzName;
    }

    private static void addClassName(List<Class<?>> clazzList, String clazzName, Class<? extends Annotation> annotation) {
        if (clazzList != null && clazzName != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(clazzName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (clazz != null) {
                if (annotation == null) {
                    clazzList.add(clazz);
                } else if (clazz.isAnnotationPresent(annotation)) {
                    clazzList.add(clazz);
                }
            }
        }
    }

    public static void checkSerializable(String ... packageNames) {
        for (String pkgName : packageNames) {
            List<Class<?>> classes = ClassUtils.getClassList(pkgName, true, null);
            for (Class<?> clazz : classes) {
                String csn = clazz.getName();
                if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isInterface() || csn.contains("$") && NumberUtils.isNumeric(csn.substring(csn.lastIndexOf("$") + 1)) || Serializable.class.isAssignableFrom(clazz)) continue;
                throw new RuntimeException("class: [" + clazz.getName() + "] must implements Serializable");
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(ClassUtils.getClassList("cn.com.duiba.wolf.cache", false, null));
    }
}

