/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.cache;

import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.NumberUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.KeyProvider;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.command.KestrelCommandFactory;
import net.rubyeye.xmemcached.command.TextCommandFactory;
import net.rubyeye.xmemcached.transcoders.SerializingTranscoder;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class XMemcacheClient
implements InitializingBean,
CacheClient {
    private static Logger logger = LoggerFactory.getLogger(XMemcacheClient.class);
    private final String CACHE_NAME = XMemcacheClient.class.getName();
    private static final int CACHE_NO_EXPIRY = 0;
    private static final int COUNTER_DEFAULT_INIT_VALUE = 0;
    private int connectionPoolSize;
    private int connectionTimeout = 60000;
    private int operationTimeout = 1000;
    private static final int DEFAULT_EXP = 172800;
    private MemcachedSessionLocator sessionLocator;
    private MemcachedClient memcachedClient;
    private String servers;
    private String authInfos;
    private String username;
    private String password;
    private boolean enableHeartBeat;
    private String protocol;

    @Override
    public <T> T get(String key) {
        key = XMemcacheClient.getStringNoBlank(key);
        try {
            return (T)this.memcachedClient.get(key);
        }
        catch (IllegalArgumentException e) {
            logger.error(String.valueOf(e.getMessage()) + ",key is:" + key);
        }
        catch (Exception e) {
            logger.error("memcachedClient get(String) error,key:" + key, (Throwable)e);
        }
        return null;
    }

    @Override
    public long getLong(String key) {
        Object obj;
        block7: {
            key = XMemcacheClient.getStringNoBlank(key);
            obj = this.memcachedClient.get(key);
            if (obj != null) break block7;
            return 0L;
        }
        try {
            if (obj instanceof String) {
                return NumberUtils.parseLong((String)obj, 0L);
            }
            if (obj instanceof Integer) {
                return ((Integer)obj).intValue();
            }
            if (obj instanceof Long) {
                return (Long)obj;
            }
        }
        catch (IllegalArgumentException e) {
            logger.error(String.valueOf(e.getMessage()) + ",key is:" + key);
        }
        catch (Exception e) {
            logger.error("memcachedClient get(String) error,key:" + key, (Throwable)e);
        }
        return 0L;
    }

    public Map<String, Object> get(Collection<String> keys) {
        Map value = null;
        try {
            value = this.memcachedClient.get(keys);
        }
        catch (Exception e) {
            logger.error("memcachedClient get(Collection<String>) error", (Throwable)e);
        }
        return value;
    }

    @Override
    public void set(String key, Object value, int expSeconds) {
        this.set(key, value, expSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void set(String key, Object value, int expiry, TimeUnit unit) {
        if (value == null) {
            return;
        }
        key = XMemcacheClient.getStringNoBlank(key);
        int exp = this.getValidExpiryTime(expiry, unit);
        try {
            this.memcachedClient.set(key, exp, value);
        }
        catch (Exception e) {
            logger.error("memcachedClient set() error,key:" + key, (Throwable)e);
        }
    }

    @Override
    public void incr(String key, long delta) {
        this.incr(key, delta, delta, 172800L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void incr(String key, long delta, long expiry, TimeUnit unit) {
        this.incr(key, delta, delta, expiry, unit);
    }

    @Override
    public void incr(String key, long delta, long initValue, long expiry, TimeUnit unit) {
        int exp = this.getValidExpiryTime(expiry, unit);
        try {
            long count = this.memcachedClient.incr(key, delta, initValue, 5000L, exp);
            logger.debug("key:{},afterInce:{}", (Object)key, (Object)count);
        }
        catch (Exception e) {
            logger.error("memcachedClient incr() error,key:" + key + this.get(key), (Throwable)e);
        }
    }

    @Override
    public void decr(String key, long delta) {
        this.decr(key, delta, 0L, 172800L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void decr(String key, long delta, long expiry, TimeUnit unit) {
        this.decr(key, delta, 0L, expiry, unit);
    }

    @Override
    public void decr(String key, long delta, long initValue, long expiry, TimeUnit unit) {
        int exp = this.getValidExpiryTime(expiry, unit);
        try {
            this.memcachedClient.decr(key, delta, initValue, 5000L, exp);
        }
        catch (Exception e) {
            logger.error("memcachedClient decr() error,key:" + key, (Throwable)e);
        }
    }

    @Override
    public void remove(String key) {
        key = XMemcacheClient.getStringNoBlank(key);
        try {
            this.memcachedClient.delete(key);
        }
        catch (Exception e) {
            logger.error("memcachedClient delete() error,key:" + key, (Throwable)e);
        }
    }

    public void setSessionLocator(MemcachedSessionLocator sessionLocator) {
        this.sessionLocator = sessionLocator;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        if (this.memcachedClient != null) {
            this.memcachedClient.setConnectTimeout((long)connectionTimeout);
        }
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
        if (this.memcachedClient != null) {
            this.memcachedClient.setOpTimeout((long)operationTimeout);
        }
    }

    public String getServers() {
        return this.servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public String getAuthInfos() {
        return this.authInfos;
    }

    public void setAuthInfos(String authInfos) {
        this.authInfos = authInfos;
    }

    public static String getStringNoBlank(String str) {
        if (str != null && !"".equals(str)) {
            return str.replaceAll("\\s*|\t|\r|\n", "").replaceAll("\u3000", "").replaceAll("&nbsp;", "");
        }
        return str;
    }

    private void initClient() {
        if (this.memcachedClient != null) {
            logger.info(String.valueOf(this.CACHE_NAME) + " already initialized");
            return;
        }
        String[] servers = StringUtils.split((String)this.getServers(), (String)",");
        String[] authInfos = StringUtils.split((String)this.getAuthInfos(), (String)",");
        ArrayList<InetSocketAddress> addressList = new ArrayList<InetSocketAddress>();
        HashMap<InetSocketAddress, AuthInfo> authInfoMap = new HashMap<InetSocketAddress, AuthInfo>();
        int i = 0;
        String[] stringArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            String server = stringArray[n2];
            InetSocketAddress address = AddrUtil.getOneAddress((String)server);
            addressList.add(address);
            if (authInfos != null && authInfos.length > 0) {
                String authInfo;
                String[] temp;
                if (authInfos != null && authInfos.length > i && (temp = (authInfo = authInfos[i]).split(":")).length >= 1) {
                    authInfoMap.put(address, AuthInfo.plain((String)temp[0], (String)temp[1]));
                    logger.info("auth " + server + " with username:" + temp[0] + ",password:" + temp[1]);
                }
            } else if (!StringUtils.isBlank((String)this.username) && !StringUtils.isBlank((String)this.password)) {
                authInfoMap.put(address, AuthInfo.plain((String)this.username, (String)this.password));
            }
            ++i;
            ++n2;
        }
        XMemcachedClientBuilder builder = new XMemcachedClientBuilder(addressList);
        builder.setAuthInfoMap(authInfoMap);
        if (this.sessionLocator != null) {
            builder.setSessionLocator(this.sessionLocator);
        }
        SerializingTranscoder transcoder = new SerializingTranscoder();
        transcoder.setCompressionThreshold(1024);
        builder.setTranscoder((Transcoder)transcoder);
        if (StringUtils.isBlank((String)this.protocol) || this.protocol.equals("BINARY")) {
            builder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
        } else if (this.protocol.equals("TEXT")) {
            builder.setCommandFactory((CommandFactory)new TextCommandFactory());
        } else if (this.protocol.equals("KESTREL")) {
            builder.setCommandFactory((CommandFactory)new KestrelCommandFactory());
        }
        builder.setKeyProvider(new KeyProvider(){

            public String process(String key) {
                if (key == null) {
                    return null;
                }
                return key.trim();
            }
        });
        builder.setHealSessionInterval(2000L);
        if (this.connectionPoolSize > 0) {
            builder.setConnectionPoolSize(this.connectionPoolSize);
        }
        try {
            this.memcachedClient = builder.build();
            this.memcachedClient.setConnectTimeout((long)this.connectionTimeout);
            this.memcachedClient.setOpTimeout((long)this.operationTimeout);
            this.memcachedClient.setEnableHeartBeat(this.enableHeartBeat);
            logger.info(addressList + " initialized{}");
        }
        catch (IOException e) {
            logger.error("Initialize " + this.getClass() + " error", (Throwable)e);
        }
    }

    public void addServer(String ... servers) throws IOException {
        if (servers == null || servers.length == 0) {
            throw new IllegalArgumentException("servers can't be null");
        }
        StringBuilder hostList = new StringBuilder();
        String[] stringArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            String server = stringArray[n2];
            hostList.append(server).append(" ");
            ++n2;
        }
        hostList.deleteCharAt(hostList.length() - 1);
        this.memcachedClient.addServer(hostList.toString());
        logger.info("Memcached server(s) added: [" + hostList + "]");
    }

    public void addServers(String[] servers, int[] weights) throws IOException {
        if (servers == null || servers.length == 0) {
            throw new IllegalArgumentException("servers can't be null");
        }
        if (weights != null && weights.length < servers.length) {
            throw new IllegalArgumentException("weights can't be less than servers");
        }
        int i = 0;
        while (i < servers.length) {
            InetSocketAddress address = AddrUtil.getOneAddress((String)servers[i]);
            this.memcachedClient.addServer(address, weights[i]);
            ++i;
        }
    }

    public void removeServer(String ... servers) {
        if (servers == null || servers.length == 0) {
            throw new IllegalArgumentException("servers can't be null");
        }
        StringBuilder hostList = new StringBuilder();
        String[] stringArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            String server = stringArray[n2];
            hostList.append(server).append(" ");
            ++n2;
        }
        hostList.deleteCharAt(hostList.length() - 1);
        this.memcachedClient.removeServer(hostList.toString());
        logger.info("Memcached server(s) removed: [" + hostList + "]");
    }

    private int getValidExpiryTime(long expiry, TimeUnit unit) {
        int exp = (int)unit.toSeconds(expiry);
        return exp > 0 ? exp : 172800;
    }

    public void afterPropertiesSet() throws Exception {
        this.initClient();
    }

    @Override
    public void putAttribute(String category, String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAttribute(String category, String key, Object value, int exp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> getAttribute(String category) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getAttribute(String category, String key) {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) throws Exception {
        XMemcacheClient client = new XMemcacheClient();
        client.setConnectionPoolSize(10);
        client.setServers("localhost:11211");
        client.afterPropertiesSet();
        Object o = client.get("cacheKeyRouterSeq_X12014031201000595");
        if (o != null) {
            System.out.println(o.getClass());
        } else {
            System.out.println("o is null");
        }
        System.out.println(client.get("1test_3"));
        System.out.println(client.get("1test_4"));
        System.out.println(client.get("1test_5"));
        System.out.println(client.get("1test_6"));
        String mapKey = "map12123";
        System.out.println(client.get(mapKey));
        System.out.println("-------------------");
        String key = "appleRepeatRequest_123211114abcda12345121abcdfe122f";
        long count = client.getLong(key);
        System.out.println("counter1:" + count);
        client.incr(key, 1L, 30L, TimeUnit.SECONDS);
        Thread.sleep(2000L);
        client.incr(key, 1L, 30L, TimeUnit.SECONDS);
        Object re = client.get(key);
        System.out.println("counter:" + re + "," + re.getClass());
        boolean i = false;
        System.out.println(client.get("what"));
        Thread.sleep(6000L);
        System.out.println(client.get("what"));
        System.exit(0);
    }

    @Override
    public void flushAll() {
        try {
            this.memcachedClient.flushAll();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setEnableHeartBeat(boolean enableHeartBeat) {
        this.enableHeartBeat = enableHeartBeat;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

