package cn.com.duiba.wolf.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

/**
 * 并发工具类
 * Created by wenqi.huang on 16/6/2.
 */
public class ConcurrentUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentUtils.class);

    private ConcurrentUtils() {
    }

    /**
     * 在线程池中运行任务并阻塞直到所有线程都完成
     *
     * @param runnables
     */
    public static void executeTasksBlocking(Executor executor, List<Runnable> runnables) {
        final CountDownLatch latch = new CountDownLatch(runnables.size());

        for (final Runnable r : runnables) {
            executor.execute(new Runnable() {
                @Override
                public void run() {
                    try {
                        r.run();
                    } finally {
                        latch.countDown();
                    }
                }
            });
        }

        try {
            latch.await();
        } catch (InterruptedException e) {
            return;
        }
    }

    /**
     * 在线程池中运行任务并阻塞直到所有线程都完成
     *
     * @param callables
     * @return Callable的结果
     */
    public static <V> List<V> submitTasksBlocking(Executor executor, List<Callable<V>> callables) {
        final CountDownLatch latch = new CountDownLatch(callables.size());
        final BlockingQueue<V> queue = new LinkedBlockingQueue<V>();

        for (final Callable<V> r : callables) {
            executor.execute(new Runnable() {

                @Override
                public void run() {
                    try {
                        V v = r.call();
                        queue.add(v);
                    } catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    } finally {
                        latch.countDown();
                    }
                }
            });
        }

        try {
            latch.await();
        } catch (InterruptedException e) {
            return new ArrayList<V>(queue);
        }
        return new ArrayList<V>(queue);
    }
}
