/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.spring.datasource;

import cn.com.duiba.wolf.spring.datasource.TransactionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class AutoRoutingDataSource
extends AbstractRoutingDataSource {
    private static final Logger logger = LoggerFactory.getLogger(AutoRoutingDataSource.class);
    private static final ThreadLocal<Boolean> contextHolder = new ThreadLocal();
    private Map<Object, Object> targetDataSources;
    private DataSource masterDataSource;
    private String masterKey;
    private String weights;
    private List<String> keyWeights;
    private int keyWeightSize;

    protected Object determineCurrentLookupKey() {
        Boolean isUseMasterDataSource = contextHolder.get();
        contextHolder.set(null);
        String key = "";
        if (isUseMasterDataSource == null) {
            logger.error("warn: isUseMasterDataSource is null,maybe you use sqlMapClient in direct way, or you are not using AutoRoutingDataSourceTransactionManager,it's not suggested. here will use masterDatasource");
            key = this.masterKey;
        } else if (isUseMasterDataSource.booleanValue()) {
            key = this.masterKey;
        } else {
            int randomNum = RandomUtils.nextInt((int)this.keyWeightSize);
            key = this.keyWeights.get(randomNum);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("use dataSource:{}, threadId:{}", (Object)key, (Object)Thread.currentThread().getId());
        }
        return key;
    }

    public void setUseMasterDataSource(boolean isUseMasterDataSource) {
        contextHolder.set(isUseMasterDataSource);
    }

    private void generateKeyWeights() {
        String[] ws;
        this.weights = StringUtils.defaultString((String)this.weights);
        ArrayList<String> weightList = new ArrayList<String>();
        ArrayList<String> datasourceIds = new ArrayList<String>();
        for (String w : ws = this.weights.split(",")) {
            if (StringUtils.isEmpty((String)(w = StringUtils.trim((String)w)))) continue;
            String[] temp = w.split(":");
            int num = Integer.valueOf(temp[1]);
            datasourceIds.add(temp[0]);
            for (int i = 0; i < num; ++i) {
                weightList.add(temp[0]);
            }
        }
        for (String string : datasourceIds) {
            if (this.targetDataSources.containsKey(string)) continue;
            throw new IllegalArgumentException("dataSourceKey:" + string + " in weights is not exist");
        }
        for (Map.Entry entry : this.targetDataSources.entrySet()) {
            String key = (String)entry.getKey();
            if (datasourceIds.contains(key)) continue;
            throw new IllegalArgumentException("dataSourceKey:" + key + " is not exist in weights");
        }
        this.keyWeights = weightList;
        this.keyWeightSize = this.keyWeights.size();
    }

    public void setTargetDataSources(Map<Object, Object> targetDataSources) {
        this.targetDataSources = targetDataSources;
        super.setTargetDataSources(targetDataSources);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.generateKeyWeights();
    }

    public void setMasterKey(String masterKey) {
        this.masterKey = masterKey;
    }

    public void setWeights(String weights) {
        this.weights = weights;
    }

    public void setDefaultTargetDataSource(DataSource defaultTargetDataSource) {
        this.masterDataSource = defaultTargetDataSource;
        super.setDefaultTargetDataSource((Object)defaultTargetDataSource);
    }

    public DataSource getMasterDataSource() {
        return this.masterDataSource;
    }

    public void determineCurrentLookupKeyByItSelf(boolean isForceUseMasterDataSource) {
        boolean isCurrentThreadInTransaction = TransactionUtils.isCurrentThreadInTransaction();
        boolean isCurrentDataSourceInTransaction = TransactionUtils.isCurrentDataSourceInTransaction((DataSource)((Object)this));
        if (isCurrentThreadInTransaction) {
            if (!isCurrentDataSourceInTransaction) {
                this.setUseMasterDataSource(true);
            }
        } else if (isForceUseMasterDataSource) {
            this.setUseMasterDataSource(true);
        } else {
            this.setUseMasterDataSource(isCurrentThreadInTransaction);
        }
    }
}

