package cn.com.duiba.zhongyan.activity.service.api.domain.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class NewActivityUserAddressDTO implements Serializable {
    private static final long serialVersionUID = -5122103544963563153L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 省名
     */
    private String province;

    /**
     * 市名
     */
    private String city;

    /**
     * 区/县名
     */
    private String area;

    /**
     * 街道名
     */
    private String street;

    /**
     * 省级行政区划编码
     */
    private String provinceCode;

    /**
     * 市级行政区划编码
     */
    private String cityCode;

    /**
     * 区县级行政区划编码
     */
    private String areaCode;

    /**
     * 乡镇级编码（可选）
     */
    private String streetCode;

    /**
     * 详细地址（不含省市区）
     */
    private String addressDetail;

    /**
     * 完整地址的MD5值（用于去重）
     */
    private String fullAddressMd5;

    /**
     * 邮政编码
     */
    private String postcode;

    /**
     * 收件人手机号
     */
    private String receiverPhone;

    /**
     * 收件人姓名
     */
    private String receiverName;

    /**
     * 中奖次数
     */
    private Integer winTimes;

    /**
     * 额外信息（JSON格式，便于扩展）
     */
    private String extra;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 最后修改时间
     */
    private Date gmtModified;
}
