package cn.com.duiba.zhongyan.activity.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.UserSpRecordDTO;

import java.util.Date;
import java.util.List;

@AdvancedFeignClient
public interface RemoteSpService {

    Long give(Long activityId, Long userId, String spId, int quantity, String playwayId, String extra);

    boolean consume(Long activityId, Long userId, String spId, int quantity, String playwayId, String extra);

    long getQuantity(Long activityId, Long userId, String spId);

    long sumQuantity(Long activityId, Long userId, String spId, String changedType, Date start, Date end);

    /**
     * 查询用户道具变更明细记录，最多查询最近1000条
     * @param activityId
     * @param userId
     * @param spId
     * @param changedType
     * @param start
     * @param end
     * @return
     */
    List<UserSpRecordDTO> queryRecordList(Long activityId, Long userId, String spId, String changedType, Date start, Date end);

    long queryRecordCount(Long activityId, String spId, String changedType, Date start, Date end);

    long queryUserCount(Long activityId, String spId, String changedType, Date start, Date end);
}
