package cn.com.duiba.zhongyan.activity.service.api.remoteservice.invite;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.DoAssistDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.invite.DoAssistParam;
import cn.com.duiba.zhongyan.activity.service.api.param.invite.GenerateInviteCodeParam;
import cn.com.duiba.zhongyan.activity.service.api.param.invite.QueryCycleInviteCountParam;
import cn.com.duiba.zhongyan.activity.service.api.param.invite.QueryTaskInviteCountParam;

/**
 * @author xuanyu
 * @description: 邀请玩法
 * @date 2022/7/14 12:31 PM
 */
@AdvancedFeignClient
public interface RemoteInviteService {

    /**
     * 生成邀请码(通用)
     * @param generateInviteCodeParam 生成邀请码参数
     * @return 邀请码
     */
    String generateInviteCode(GenerateInviteCodeParam generateInviteCodeParam) throws BizException;

    /**
     * 助力(通用)
     * @param doAssistParam 助力参数
     */
    DoAssistDTO doAssist(DoAssistParam doAssistParam) throws BizException;

    /**
     * 查询周期内用户已邀请人数
     * @param queryCycleInviteCountParam 查询参数
     * @return 查询用户已邀请人数
     * @throws BizException
     */
    Long queryCycleInviteCount(QueryCycleInviteCountParam queryCycleInviteCountParam) throws BizException;

    /**
     * 查询未读的邀请人数
     * @param queryCycleInviteCountParam
     * @return 0代表无未读人数 其余数值代表邀请人数
     * @throws BizException
     */
    Long queryUnReadInviteCount(QueryCycleInviteCountParam queryCycleInviteCountParam) throws BizException;


   Integer queryTaskInviteCount(QueryTaskInviteCountParam queryTaskInviteCountParam);

    /**
     * 助力成功 助力人数
     * @param queryTaskInviteCountParam
     * @return
     */
   Integer queryTaskDoAssistCount(QueryTaskInviteCountParam  queryTaskInviteCountParam);

    /**
     * 分享助力成去重
     * @param queryTaskInviteCountParam
     * @return
     */
   Integer queryTaskShareCount(QueryTaskInviteCountParam  queryTaskInviteCountParam);


    /**
     * 助力(九宫格-定制)
     * @param doAssistParam 助力参数
     */
    DoAssistDTO nineGridDoAssist(DoAssistParam doAssistParam) throws BizException;

    /**
     * 助力(任务签到-定制)
     * @param doAssistParam 助力参数
     */
    DoAssistDTO taskSignDoAssist(DoAssistParam doAssistParam) throws BizException;

    /**
     * 查询邀请码是否合法
     * @param activityId
     * @param inviteCode
     * @return
     */
    Boolean checkInviteCodeStatus(Long activityId,String inviteCode);
}
