package cn.com.duiba.zhongyan.activity.service.api.remoteservice.saleuser;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.SaleUserInfoDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser.SaleUserInfoDto;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser.UserInfoDto;
import cn.com.duiba.zhongyan.activity.service.api.param.saleuser.SaveMobileParam;

import java.util.List;

/**
 * @author linzhou
 * @ClassName SaleUserInfoService.java
 * @createTime 2022年03月11日 13:42:00
 * @Description
 */
@AdvancedFeignClient
public interface RemoteSaleUserInfoService {

    /**
     * 绑定手机号
     *
     * @param param
     * @return
     */
    Boolean addMobile(SaveMobileParam param) throws BizException;

    /**
     * 修改手机号
     *
     * @param param
     * @return
     */
    Boolean updateMobile(SaveMobileParam param) throws BizException;

    /**
     * 手机号申诉
     *
     * @param param
     * @return
     */
    Boolean checkSaleUserInfoMobile(SaveMobileParam param) throws BizException;

    /**
     * 查询用户手机号
     *
     * @param cId 用户id
     * @return
     */
    SaleUserInfoDto getUserInfo(Long cId);



    /**
     * 获取用户信息
     *
     * @param cId
     * @return
     */
    UserInfoDto getUserInfoDto(Long cId);

    /**
     * 批量查询零售户手机号
     * @param cidList 查询参数
     * @return List<SaleUserInfoEntity>
     */
    List<SaleUserInfoDTO> getUserInfoList(List<Long> cidList);
}
