package cn.com.duiba.zhongyan.activity.service.api.base;

import java.io.Serializable;

/**
 * @author LuHui
 * @description
 * @date 2021/11/26  13:53
 */
public class JsonResult<T> implements Serializable {
    private static final long serialVersionUID = -4013056288290917503L;

    /**
     * 默认失败码
     */
    private static final String DEFAULT_FAIL_CODE = "-1";

    /**
     * 默认成功码
     */
    private static final String DEFAULT_SUCCESS_CODE = "0";

    /**
     * 操作是否成功
     */
    private boolean success;

    /**
     * 描述
     */
    private String message;

    /**
     * 数据包体
     */
    private T  data;

    /**
     * 返回code
     */
    private String  code;


    private JsonResult() {
    }

    /**
     * 带自定义响应码的描述信息数据对象Result
     *
     * @param code 错误码
     * @param desc 失败描述
     * @return Result
     */
    public static <T> JsonResult<T> fail(String code, String desc) {
        JsonResult<T> result = new JsonResult<>();
        result.setSuccess(false);
        result.setCode(code);
        result.setMessage(desc);
        return result;
    }

    /**
     * 使用默认错误码,描述错误信息(统一使用默认错误码)
     *
     * @param desc 失败描述
     * @return JsonResult
     */
    public static <T> JsonResult<T> fail(String desc) {
        return fail(DEFAULT_FAIL_CODE, desc);
    }

    /**
     * 带有数据的失败返回
     *
     * @param code 失败码
     * @param desc 失败信息
     * @param data 数据
     * @return JsonResult
     */
    public static <T> JsonResult<T> fail(String code, String desc, T data) {
        JsonResult<T> result = new JsonResult<>();
        result.setSuccess(false);
        result.setCode(code);
        result.setMessage(desc);
        result.setData(data);
        return result;
    }

    /**
     * 带有数据的失败返回,统一使用默认错误码
     *
     * @param desc 失败信息
     * @param data 数据
     * @return JsonResult
     */
    public static <T> JsonResult<T> fail(String desc, T data) {
        return fail(DEFAULT_FAIL_CODE, desc, data);
    }

    /**
     * 使用自定义成功码的成功数据对象构建
     *
     * @param code 成功码
     * @param data 数据
     * @return JsonResult
     */
    public static <T> JsonResult<T> success(String code, T data) {
        JsonResult<T> result = new JsonResult<>();
        result.setSuccess(true);
        result.setCode(code);
        result.setData(data);
        result.setMessage("OK");
        return result;
    }

    /**
     * 统一使用默认成功码的成功数据对象构建
     *
     * @param data 数据
     * @return JsonResult
     */
    public static <T> JsonResult<T> success(T data) {
        return success(DEFAULT_SUCCESS_CODE, data);
    }

    /**
     * 成功,不返回任何数据,统一使用默认成功码
     *
     * @return
     */
    public static <T> JsonResult<T> success() {
        return success(DEFAULT_SUCCESS_CODE, null);
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

}
