package cn.com.duiba.zhongyan.activity.service.api.enums;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * @author LuHui
 * @description
 * @date 2021/11/25  17:06
 */
public enum ActivityStatusEnum{
    ACTIVITY_ALREADY_START(0, "进行中"),
    ACTIVITY_NOT_START(1, "未开始"),
    ACTIVITY_ALREADY_END(2, "已结束");

    private int code;

    private String desc;

    ActivityStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


    /**
     * 获取活动状态
     * @param startTime
     * @param endTime
     * @return
     */
    public static int getActivityStatus(String startTime, String endTime){
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (LocalDateTime.now().isBefore(LocalDateTime.parse(startTime, df))){
            return ACTIVITY_NOT_START.code;
        }else if(LocalDateTime.now().isAfter(LocalDateTime.parse(endTime, df))){
            return ACTIVITY_ALREADY_END.code;
        }else {
            return ACTIVITY_ALREADY_START.code;
        }
    }

    /**
     * 获取活动状态
     * @param startTime
     * @param endTime
     * @return
     */
    public static int getActivityStatus(Date startTime, Date endTime){
        Date now = new Date();
        if (now.before(startTime)){
            return ACTIVITY_NOT_START.code;
        }else if (now.after(endTime)){
            return ACTIVITY_ALREADY_END.code;
        }else {
            return ACTIVITY_ALREADY_START.code;
        }
    }
}
