package cn.com.duiba.zhongyan.activity.service.api.enums;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/3/21
 */
public enum PrizeReceiveStatusEnum {
    READY(1,"待领取"),
    RECEIVED(2,"已领取"),
    EXPIRE(3,"已过期"),
    ;

    private Integer type;

    private String desc;
    PrizeReceiveStatusEnum(Integer type,String desc){
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getByType(Integer type){
        for (PrizeReceiveStatusEnum status : PrizeReceiveStatusEnum.values()){
            if(status.getType().equals(type)){
                return status.getDesc();
            }
        }
        return "";
    }

}
