package cn.com.duiba.zhongyan.activity.service.api.enums.record;

/**
 * @author wangxukai
 * @description ai识别反馈
 * @date ：Created in 2022/5/17
 */
public enum SaleDistinguishFeedbackEnum {

    A(1,"图片比较清晰可以识别"),
    B(2,"照片角度正常但识别结果显示角度不正常"),
    C(3,"识别到的专卖证号和照片中的不一致"),
    D(4,"图片是许可证，但识别结果显示不是许可证"),
    E(5,"其他");
    private Integer type;

    private String desc;
    SaleDistinguishFeedbackEnum(Integer type,String desc){
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getByType(Integer type){
        for(SaleDistinguishFeedbackEnum feedbackEnum : SaleDistinguishFeedbackEnum.values()){
            if(feedbackEnum.getType().equals(type)){
                return feedbackEnum.getDesc();
            }
        }
        return "";
    }
}
