package cn.com.duiba.zhongyan.activity.service.api.param.saleuser;

import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author linzhou
 * @ClassName SortDTO.java
 * @createTime 2022年03月16日 14:43:00
 * @Description
 */
@Data
public class SortParam implements Serializable {

    private List<SortItemParam> sortItemParamList;


    public String getOrderBy() {
        if (CollectionUtils.isEmpty(sortItemParamList)) {
            return null;
        }
        return "order by "+sortItemParamList.stream().map(SortItemParam::getOrderBy).collect(Collectors.joining(","));
    }

    @Data
    public static class SortItemParam implements Serializable{
        /**
         * 排序字段
         */
        private String fieldName;
        /**
         * 排序方式 0:升序 1:降序
         */
        private int sort = 0;

        public String getOrderBy() {
            if (sort == 0) {
                return fieldName;
            }

            return fieldName + " desc";
        }

    }

}
