package cn.com.duiba.zhongyan.activity.service.api.param.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 退还预占库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/17 9:38 下午
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
public class RollbackOccupyStockParam implements Serializable {
    private static final long serialVersionUID = 252682011096195814L;

    /**
     * 调度作用域id 如活动id
     */
    @NotNull(message = "预占泛id不能为空")
    private Long generalId;

    /**
     * 用户id
     */
    @NotNull(message = "userId不能为空")
    private Long userId;

    /**
     * 用户类型(1:平台;2:租户;3:用户)
     */
    @NotNull(message = "用户类型不能为空")
    private Integer userType;
}