package cn.com.duiba.zhongyan.activity.service.api.remoteservice.scanCode;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.record.ActivityScanDetailDataDto;
import cn.com.duiba.zhongyan.activity.service.api.param.scanCode.RemoteLastParticipateParam;
import cn.com.duiba.zhongyan.activity.service.api.param.scanCode.RemoteUpdateStatisticsParam;

import java.util.List;

/**
 * @author xiaotian
 * @description: 扫码统计对外服务
 * @date 2022/03/18 6:07 下午
 */
@AdvancedFeignClient
public interface RemoteScanCodeStitisticsService {

    /**
     * 更新最后的访问时间
     * @param remoteLastParticipateParam
     * @return
     */
    boolean updateLastParticipateTime(RemoteLastParticipateParam remoteLastParticipateParam);


    /**
     * 重新计算数据
     * @param remoteUpdateStatisticsParam
     * @return
     */
    boolean flush(RemoteUpdateStatisticsParam remoteUpdateStatisticsParam);

    /**
     * 根据扫码活动id查询活动积分情况
     * @param activityId
     * @return
     */
    List<ActivityScanDetailDataDto> getDetailByActivityId(Long activityId);

}
