package cn.com.duiba.zhongyan.activity.service.api.remoteservice.statistics;

import cn.com.duiba.wolf.utils.DateUtils;

import java.util.Date;
import java.util.Objects;

/**
 * 防作弊中心 统计key
 */
public interface CheatCenterStatisticsConfig {

    /**
     * 访问pv总量key（总）
     */
    String TOTAL_CHEAT_ALL_PV = "cheat_all_pv";
    static String getTotalCheatAllPv() {
        return TOTAL_CHEAT_ALL_PV;
    }


    /**
     * 黑名单撞库量（总）
     */
    String CHEAT_BLACK_PV = "cheat_black_pv";
    static String getCheatBlackPv() {
        return CHEAT_BLACK_PV;
    }

    /**
     * 灰名单撞库量（总）
     */
    String CHEAT_GREY_PV = "cheat_grey_pv";
    static String getCheatGreyPv() {
        return CHEAT_GREY_PV;
    }

    /**
     * 每日黑名单撞库量key（每日）
     */
    String CHEAT_BLACK_DAY_PV = "cheat_black_pv_%s";
    static String getCheatBlackDayPv(Date day) {
        if(Objects.isNull(day)){
            day = new Date();
        }
        int dayNumber = DateUtils.getDayNumber(day);
        return String.format(CHEAT_BLACK_DAY_PV, dayNumber);
    }

    /**
     * 每日黑名单撞库量key
     */
    String CHEAT_GREY_DAY_PV = "cheat_grey_pv_%s";
    static String getCheatGreyDayPv(Date day) {
        if(Objects.isNull(day)){
            day = new Date();
        }
        int dayNumber = DateUtils.getDayNumber(day);
        return String.format(CHEAT_GREY_DAY_PV, dayNumber);
    }

}
