package cn.com.duiba.zhongyan.activity.service.api.utils.validate;

import cn.com.duiba.boot.exception.BizException;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import java.io.Serializable;
import java.util.Set;

/**
 * jsr303手动校验
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/10
 */
public class ValidatorUtil {

    /**
     * 工厂
     */
    private static final ValidatorFactory FACTORY = Validation.buildDefaultValidatorFactory();

    /**
     * 验证器
     *
     * @param t t
     * @throws BizException 业务异常
     */
    public static <T extends Serializable> void validator(T t) throws BizException {
        Validator validator = FACTORY.getValidator();
        Set<ConstraintViolation<T>> errorSet = validator.validate(t);
        if (!errorSet.isEmpty()) {
            for (ConstraintViolation<T> anErrorSet : errorSet) {
                // 仅抛出第一个异常即可
                throw new BizException(anErrorSet.getMessage());
            }
        }
    }

}
