package cn.com.duiba.cloud.manage.service.api.model.dto.report.export;

import com.alibaba.excel.annotation.ExcelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 公众号粉丝变化
 * @author xuanhongjian
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@SuppressWarnings("all")
public class WechatFansExportData implements Serializable {
    private static final long serialVersionUID = 1102718850533441228L;
    /**
     * 日期
     */
    @ExcelProperty("时间")
    private Date curDate;

    /**
     * '新关注人数'
     */
    @ExcelProperty("新关注人数")
    private Long summaryNewUser;

    /**
     * '取消关注人数'
     */
    @ExcelProperty("取消关注人数")
    private Long summaryCancelUser;

    /**
     * '净增关注人数'
     */
    @ExcelProperty("净增关注人数")
    private Long cumulateNewUser;

    /**
     * '累计关注人数'
     */
    @ExcelProperty("累计关注人数")
    private Long cumulateCancelUser;
}
