package cn.com.duiba.cloud.manage.service.api.model.dto.report;

import com.alibaba.excel.annotation.ExcelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 平和味道报表
 *
 * @author xuanhongjian
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@SuppressWarnings("all")
public class PhwdDTO implements Serializable {
    private static final long serialVersionUID = 1102718850533441228L;
    /**
     * 日期
     */
    private Date curDate;

    /**
     * 平和味道公众号关注粉丝量-合计
     */
    private Long phwdFollowFansUv;

    /**
     * 平和味道公众号关注粉丝量-省内
     */
    private Long phwdFollowFansInsideUv;

    /**
     * 平和味道公众号关注粉丝量-省外
     */
    private Long phwdFollowFansOutsideUv;

    /**
     * 平和味道粉丝注册量
     */
    private Long phwdRegisterFansTotalUv;

    /**
     * 新增入网量-合计
     */
    private Long increApprovalCntUv;

    /**
     * 新增入网量-省内
     */
    private Long increApprovalInsideUv;

    /**
     * 新增入网量-省外
     */
    private Long increApprovalOutsideUv;

    /**
     * 累计入网量-合计
     */
    private Long accumulateApprovalCntUv;

    /**
     * 累计入网量-省内
     */
    private Long accumulateApprovalInsideUv;

    /**
     * 累计入网量-省外
     */
    private Long accumulateApprovalOutsideUv;

    /**
     * 新增入网量剔除已获知取关量-合计
     */
    private Long eliminateIncreApprovalCntUv;

    /**
     * 新增入网量剔除已获知取关量-省内
     */
    private Long eliminateIncreApprovalInsideUv;

    /**
     * 新增入网量剔除已获知取关量-省外
     */
    private Long eliminateIncreApprovalOutsideUv;

    /**
     * 累计入网量剔除已获知取关量-合计
     */
    private Long eliminateAccumulateApprovalCntUv;

    /**
     * 累计入网量剔除已获知取关量-省内
     */
    private Long eliminateAccumulateApprovalInsideUv;

    /***
     * '累计入网量剔除已获知取关量-省外'
     */
    private Long eliminateAccumulateApprovalOutsideUv;

    /**
     * '零售户活动交互（活动交互）'
     */
    private Long retailerActivityParticipationPv;

    /**
     * '消费者活动交互（活动交互）'
     */
    private Long consumerActivityParticipationPv;

    /**
     * '推文阅读量（宣传交互）'
     */
    private Long tweetReadingPv;
}
