package cn.com.duiba.cloud.manage.service.api.model.param.plan;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description
 * @Date 2022/9/14 16:26
 * @Author LuHui
 */
@Data
public class RemoteEsPlanQueryParam implements Serializable {
    private static final long serialVersionUID = 8614750244716190315L;

    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 版块id
     */
    private Long templateId;
    /**
     * 部门id
     */
    private Integer departmentId;
    /**
     * 活动开始时间
     */
    private Date startTime;
    /**
     * 活动结束时间
     */
    private Date endTime;
    /**
     * 品规编码
     */
    private String regulateCode;
    /**
     * 活动类型
     */
    private Integer activityType;
    /**
     * 负责人编号
     */
    private String dutyPersonId;
    /**
     * 活动状态 0:待确认 1:已确认 2:筹备中 3:筹备完成 4:进行中 5:已结束 6:已关闭
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.plan.PlanStatusEnum
     */
    private Integer status;
    /**
     * 状态过滤
     */
    private List<Integer> filterStatusList;
    /**
     * 部门id
     */
    private List<Integer> departmentIdList;
    /**
     * 筹备中时间
     */
    private Date prepareDate;
    /**
     * 已确定时间
     */
    private Date confirmDate;
}
