package cn.com.duiba.cloud.manage.service.api.model.dto.datav.scan;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 积分消耗详情DTO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-10-19 20:40
 * @since 3.0.6
 **/
@Data
public class CreditsConsumeStatisticalDTO implements Serializable {
    private static final long serialVersionUID = -740547180364817529L;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 累计发放积分
     */
    private Integer cumulativeGrantCredits;

    /**
     * 兑换消耗值
     */
    private Integer exchangeConsume;

    /**
     * 兑换占比
     */
    private BigDecimal exchangeProportion;

    /**
     * 抽奖消耗值
     */
    private Integer luckyConsume;

    /**
     * 抽奖比例
     */
    private BigDecimal luckyProportion;

    /**
     * 剩余积分值
     */
    private Integer remainCredits;

    /**
     * 剩余积分值占比
     */
    private BigDecimal remainProportion;
}
