package cn.com.duiba.cloud.manage.service.api.remoteservice.page;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.page.DesignUnitDto;
import cn.com.duiba.cloud.manage.service.api.model.param.page.RemoteDesignUnitCreateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.page.RemoteDesignUnitInitParam;
import cn.com.duiba.cloud.manage.service.api.model.param.page.RemoteDesignUnitQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/2/9
 */
@AdvancedFeignClient
public interface RemoteDesignUnitService {
    /**
     * 组件初始化
     *
     * @param param
     * @return
     */
    Boolean init(RemoteDesignUnitInitParam param);

    /**
     * 更新组件信息
     *
     * @param param
     * @return
     */
    Boolean update(RemoteDesignUnitCreateParam param);

    /**
     * 查询组件列表
     *
     * @param param
     * @return
     */
    PageResponse<DesignUnitDto> queryList(RemoteDesignUnitQueryParam param);

    /**
     * 根据id列表查询
     *
     * @param ids
     * @return
     */
    List<DesignUnitDto> queryByIds(List<Long> ids);


    /**
     * 根据组件标识列表查询
     *
     * @param flags
     * @return
     */
    List<DesignUnitDto> queryByFlags(List<String> flags);
}
