package cn.com.duiba.cloud.manage.service.api.utils;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description 同 shardingsphere aes 加解密
 * @date 2021/12/8 14:20
 */
public class AesUtil {

    private static byte[] createSecretKey(String aesKey) {
        return Arrays.copyOf(DigestUtils.sha1(aesKey), 16);
    }

    /**
     * AES 加密方法
     *
     * @param plaintext 加密文本
     * @param aesKey    加密 key
     */
    public static String encrypt(String plaintext, String aesKey) {
        try {
            if (null == plaintext) {
                return null;
            } else {
                byte[] result = getCipher(1, aesKey).doFinal(StringUtils.getBytesUtf8(plaintext));
                return Base64.encodeBase64String(result);
            }
        } catch (GeneralSecurityException var3) {
            throw new RuntimeException("aes 加密错误");
        }
    }

    /**
     * AES 解密方法
     *
     * @param ciphertext 密码
     * @param aesKey     加密 Key
     */

    public static String decrypt(String ciphertext, String aesKey) {
        try {
            if (null == ciphertext) {
                return null;
            } else {
                byte[] result = getCipher(2, aesKey).doFinal(Base64.decodeBase64(ciphertext));
                return new String(result, StandardCharsets.UTF_8);
            }
        } catch (GeneralSecurityException var3) {
            throw new RuntimeException("aes 解密错误");
        }
    }

    private static Cipher getCipher(int decryptMode, String aesKey) {
        Cipher result = null;
        try {
            result = Cipher.getInstance(getType());
            result.init(decryptMode, new SecretKeySpec(createSecretKey(aesKey), getType()));
        } catch (NoSuchAlgorithmException | NoSuchPaddingException | InvalidKeyException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getType() {
        return "AES";
    }
}
