package cn.com.duiba.cloud.manage.service.api.model.param.staff;

import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * @author linzhou
 * @ClassName GetStaffByDeptIdParam.java
 * @createTime 2021年11月02日 11:39:00
 * @Description
 */
@Getter
@Setter
public class RemoteGetStaffByDeptIdRequest extends BaseParam {

    private static final long serialVersionUID = -1129343235992902211L;
    /**
     * 部门id
     */
    private Long deptId;

    /**
     * 名字
     */
    private String staffName;

    /**
     * 主键id list
     */
    private List<Long> ids;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * 员工编号
     */
    private String userId;

    /**
     * 当前页码。从1开始计数
     */
    private int pageNo;

    /**
     * 每页记录数
     */
    private int pageSize;

    /**
     * 内部id
     */
    private List<Long> innerIdList;

    public int getOffset() {
        return (this.pageNo - 1) * this.pageSize;
    }
}
